// Background service worker for handling API requests
// This avoids CORS issues since service workers are not subject to webpage CORS policies

chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    if (request.action === 'saveArticle') {
        fetch('https://haowen.aiykekko.com/api/save', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            credentials: 'omit',
            body: JSON.stringify(request.data)
        })
            .then(response => response.json())
            .then(result => {
                sendResponse({ success: true, result: result });
            })
            .catch(error => {
                console.error('Background fetch error:', error);
                sendResponse({ success: false, error: error.message });
            });

        // Return true to indicate async response
        return true;
    }
});
