// Create Floating Button
const fab = document.createElement('div');
fab.id = 'red-ink-fab';
fab.innerHTML = '<span>➕</span>'; // Simple icon
fab.title = '保存到小杨推荐';
document.body.appendChild(fab);

// Create Modal (Hidden by default)
const modal = document.createElement('div');
modal.id = 'red-ink-modal';
modal.innerHTML = `
  <div class="red-ink-modal-content">
    <h3>保存到小杨推荐</h3>
    <textarea id="red-ink-review" placeholder="写下您的想法..."></textarea>
    <div class="red-ink-actions">
        <button id="red-ink-cancel">取消</button>
        <button id="red-ink-save">确认保存</button>
    </div>
    <div id="red-ink-status"></div>
  </div>
`;
document.body.appendChild(modal);

// Elements
const reviewInput = document.getElementById('red-ink-review');
const saveBtn = document.getElementById('red-ink-save');
const cancelBtn = document.getElementById('red-ink-cancel');
const statusMsg = document.getElementById('red-ink-status');

// Toggle Modal
fab.addEventListener('click', () => {
    modal.style.display = 'flex';
});

cancelBtn.addEventListener('click', () => {
    modal.style.display = 'none';
});

// Close when clicking outside
modal.addEventListener('click', (e) => {
    if (e.target === modal) {
        modal.style.display = 'none';
    }
});

// Save Logic
saveBtn.addEventListener('click', async () => {
    const review = reviewInput.value;
    const data = {
        title: document.title,
        url: window.location.href,
        review: review
    };

    saveBtn.disabled = true;
    saveBtn.innerText = "保存中...";
    statusMsg.innerText = "";

    try {
        // 通过 background script 发送请求以避免 CORS 问题
        chrome.runtime.sendMessage(
            { action: 'saveArticle', data: data },
            (response) => {
                if (chrome.runtime.lastError) {
                    statusMsg.style.color = "red";
                    statusMsg.innerText = "网络错误: " + chrome.runtime.lastError.message;
                    console.error(chrome.runtime.lastError);
                    saveBtn.disabled = false;
                    saveBtn.innerText = "确认保存";
                    return;
                }

                if (response && response.success && response.result && response.result.code === 0) {
                    statusMsg.style.color = "green";
                    statusMsg.innerText = "保存成功！";
                    setTimeout(() => {
                        modal.style.display = 'none';
                        saveBtn.disabled = false;
                        saveBtn.innerText = "确认保存";
                        statusMsg.innerText = "";
                        reviewInput.value = ""; // Clear input
                    }, 1500);
                } else {
                    statusMsg.style.color = "red";
                    const errorMsg = response?.result?.msg || response?.error || "未知错误";
                    statusMsg.innerText = "失败: " + errorMsg;
                    saveBtn.disabled = false;
                    saveBtn.innerText = "确认保存";
                }
            }
        );
    } catch (error) {
        statusMsg.style.color = "red";
        statusMsg.innerText = "网络错误";
        console.error(error);
        saveBtn.disabled = false;
        saveBtn.innerText = "确认保存";
    }
});
