// Create Floating Button
const fab = document.createElement('div');
fab.id = 'red-ink-fab';
fab.innerHTML = '<span>➕</span>'; // Simple icon
fab.title = '保存到小杨推荐';
document.body.appendChild(fab);

// Create Modal (Hidden by default)
const modal = document.createElement('div');
modal.id = 'red-ink-modal';
modal.innerHTML = `
  <div class="red-ink-modal-content">
    <h3>保存到小杨推荐</h3>
    <textarea id="red-ink-review" placeholder="写下您的想法..."></textarea>
    <div class="red-ink-actions">
        <button id="red-ink-cancel">取消</button>
        <button id="red-ink-save">确认保存</button>
    </div>
    <div id="red-ink-status"></div>
  </div>
`;
document.body.appendChild(modal);

// Elements
const reviewInput = document.getElementById('red-ink-review');
const saveBtn = document.getElementById('red-ink-save');
const cancelBtn = document.getElementById('red-ink-cancel');
const statusMsg = document.getElementById('red-ink-status');

// Toggle Modal
fab.addEventListener('click', () => {
    modal.style.display = 'flex';
});

cancelBtn.addEventListener('click', () => {
    modal.style.display = 'none';
});

// Close when clicking outside
modal.addEventListener('click', (e) => {
    if (e.target === modal) {
        modal.style.display = 'none';
    }
});

// Save Logic
saveBtn.addEventListener('click', async () => {
    const review = reviewInput.value;
    const data = {
        title: document.title,
        url: window.location.href,
        review: review
    };

    saveBtn.disabled = true;
    saveBtn.innerText = "保存中...";
    statusMsg.innerText = "";

    try {
        const response = await fetch('https://xiaoyangyouxuan.vercel.app/api/save', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(data)
        });

        const result = await response.json();

        if (response.ok && result.code === 0) {
            statusMsg.style.color = "green";
            statusMsg.innerText = "保存成功！";
            setTimeout(() => {
                modal.style.display = 'none';
                saveBtn.disabled = false;
                saveBtn.innerText = "确认保存";
                statusMsg.innerText = "";
                reviewInput.value = ""; // Clear input
            }, 1500);
        } else {
            statusMsg.style.color = "red";
            statusMsg.innerText = "失败: " + (result.msg || "未知错误");
            saveBtn.disabled = false;
            saveBtn.innerText = "确认保存";
        }
    } catch (error) {
        statusMsg.style.color = "red";
        statusMsg.innerText = "网络错误";
        console.error(error);
        saveBtn.disabled = false;
        saveBtn.innerText = "确认保存";
    }
});
