document.addEventListener('DOMContentLoaded', async () => {
    const reviewInput = document.getElementById('review-input');
    const saveBtn = document.getElementById('save-btn');
    const statusMsg = document.getElementById('status-msg');

    // Get current tab info
    const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });

    saveBtn.addEventListener('click', async () => {
        const review = reviewInput.value;
        const data = {
            title: tab ? tab.title : "",
            url: tab ? tab.url : "",
            review: review
        };

        saveBtn.disabled = true;
        saveBtn.innerText = "正在保存...";
        statusMsg.innerText = "";

        try {
            const response = await fetch('https://xiaoyangyouxuan.vercel.app/api/save', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(data)
            });

            const result = await response.json();

            if (response.ok && result.code === 0) {
                statusMsg.style.color = "green";
                statusMsg.innerText = "保存成功！";
                setTimeout(() => window.close(), 1500);
            } else {
                statusMsg.style.color = "red";
                statusMsg.innerText = "失败: " + (result.msg || "未知错误");
                saveBtn.disabled = false;
                saveBtn.innerText = "保存到小杨推荐";
            }
        } catch (error) {
            statusMsg.style.color = "red";
            statusMsg.innerText = "网络错误，请检查网络连接";
            console.error(error);
            saveBtn.disabled = false;
            saveBtn.innerText = "保存到小杨推荐";
        }
    });
});
